<?php
require_once __DIR__ . '/auth.php';
require_login();

header('Content-Type: application/json; charset=utf-8');

$uploadDir = __DIR__ . '/uploads/';
if (!is_dir($uploadDir)) {
    if (!mkdir($uploadDir, 0755, true)) {
        echo json_encode(['success'=>false,'message'=>'Não foi possível criar pasta uploads.']);
        exit;
    }
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success'=>false,'message'=>'Método inválido']);
    exit;
}

if (!isset($_FILES['file'])) {
    echo json_encode(['success'=>false,'message'=>'Arquivo não enviado']);
    exit;
}

$type = isset($_POST['type']) ? preg_replace('/[^a-z0-9_-]/i','', $_POST['type']) : 'other';
$file = $_FILES['file'];

$finfo = finfo_open(FILEINFO_MIME_TYPE);
$mime = finfo_file($finfo, $file['tmp_name']);
finfo_close($finfo);

$allowed = ['image/png','image/jpeg','image/jpg','image/webp'];
if (!in_array($mime, $allowed)) {
    echo json_encode(['success'=>false,'message'=>'Tipo de arquivo não permitido. Use PNG/JPG/WEBP.']);
    exit;
}

if ($file['size'] > 8 * 1024 * 1024) {
    echo json_encode(['success'=>false,'message'=>'Arquivo muito grande (max 8MB).']);
    exit;
}

$ext = pathinfo($file['name'], PATHINFO_EXTENSION);
$basename = ($type === 'logo' ? 'logo_' : ($type === 'bg' ? 'bg_' : 'file_')) . time() . '_' . bin2hex(random_bytes(4)) . '.' . $ext;
$target = $uploadDir . $basename;

if (!move_uploaded_file($file['tmp_name'], $target)) {
    echo json_encode(['success'=>false,'message'=>'Erro ao salvar arquivo.']);
    exit;
}

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
$host = $_SERVER['HTTP_HOST'];
$dir = rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
$url = $protocol . '://' . $host . $dir . '/uploads/' . $basename;

echo json_encode(['success'=>true,'url'=>$url]);
exit;